/*
 * MultiServerThread.java
 *
 * 
 */
 package	DisCSP.DistributedCSP;

import java.io.*;
import java.net.*;
import DisCSP.CSP.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


public class MultiServerThread  extends Thread
{
	private int PORT;
	private DisConstraintProblem disCP;
	private Neighbourhood nhood;
	private AgentState state;
	private PrintStream output;

 	/** Costruttore di MultiServerThread
     * 
     * @param dis il problema associato all'agente
     * @param p la porta dell'agente
     * @param n i vicini dell' agente
     * @param s lo stato dell'agente
     * @param o il PrintStream su cui direzionare l'output
     * 
     */	
	public MultiServerThread(DisConstraintProblem dis, int p, Neighbourhood n,AgentState s,PrintStream o)
	{
		disCP=dis;
		PORT=p;
		nhood=n;
		state=s;
		output=o;
	}
	
	/** Metodo run del Thread
     * 
     * 
     */	

	public  void run()
	{
		try
		{
			ServerSocket serverSocket =	new	ServerSocket(PORT);
			while(!state.impossible()&&!state.consistent())
			{
				// bloccante finch	non	avviene	una	connessione:
				
				Socket clientSocket	= serverSocket.accept();
				try
				{
					new ServerThread(clientSocket, disCP,nhood,state,output);
				}
				catch(IOException e)
				{
					clientSocket.close();
		  		}
	  		}
	  		serverSocket.close();
		}
		catch (Exception e)
		{
			output.println(state.getName()+" "+"can't accept any connection.");
		}
		
	

	}

} 

